/*
 * coreHTTP v3.1.1
 * Copyright (C) 2024 Amazon.com, Inc. or its affiliates.  All Rights Reserved.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file HTTPClient_ReadHeader_harness.c
 * @brief Implements the proof harness for HTTPClient_ReadHeader function.
 */

#include "core_http_client.h"

#include "http_cbmc_state.h"

void HTTPClient_ReadHeader_harness()
{
    HTTPResponse_t * pResponse;
    char * pField;
    char ** pValue;
    size_t fieldLen;
    size_t valueLen;

    /* Initialize and make assumptions for header field. */
    __CPROVER_assume( fieldLen < CBMC_MAX_OBJECT_SIZE );
    pField = mallocCanFail( fieldLen );

    /* Initialize and make assumptions for header value. */
    __CPROVER_assume( valueLen < CBMC_MAX_OBJECT_SIZE );
    pValue = mallocCanFail( sizeof( char * ) );

    /* Initialize and make assumptions for response object. */
    pResponse = allocateHttpResponse( NULL );
    __CPROVER_assume( isValidHttpResponse( pResponse ) );

    HTTPClient_ReadHeader( pResponse,
                           pField,
                           fieldLen,
                           pValue,
                           valueLen );
}
